//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD ThreadWaitForDisconnect(Client *pClient)
{
    if(pClient->Connected)
    {
        pClient->Disconnect = true;

        while(pClient->Connected)
        {
            // Waiting for client to be disconnected
            Sleep(1);
        }
    }

    CloseHandle(Client_Thread_Handle);
    Client_Thread_ID = 0;

    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread(LPVOID xData)
{
    if(MyClient.Connected)
    {
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Already connected.", -1);
        return ThreadWaitForDisconnect(&MyClient);
    }

    Set_Text(MDI.RecvEdit_hWnd, "");

    InsertListBoxItem(MDI.RecvEdit_hWnd, "Please wait... Connecting.", -1);

    if(MyClient.Connect(gsWPServer, 6632))
    {
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Connected.", -1);
    }
    else{
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Failed to connect.", -1);

        return ThreadWaitForDisconnect(&MyClient);
    }

    InsertListBoxItem(MDI.RecvEdit_hWnd, "Waiting on server to respond.", -1);

    int AuthResult = AuthenticateWithServer();
    if(AuthResult == AUTH_CMD_SUCCESS)
    {
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Authentication: Success.", -1);
        DoConnect();
    }
    else if(AuthResult == AUTH_CMD_FAILED){
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Authentication: Failed.", -1);
        MyClient.Disconnect = true;
        return ThreadWaitForDisconnect(&MyClient);
    }
    else if(AuthResult == AUTH_CMD_DISCONNECT){
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Authentication: Disconnected.", -1);
        MyClient.Disconnect = true;
        return ThreadWaitForDisconnect(&MyClient);
    }
    else{
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Authentication: Error.", -1);
        MyClient.Disconnect = true;
        return ThreadWaitForDisconnect(&MyClient);
    }

    char SendBuffer[MaxReceiveSize + 1];
    int SendSize = 0;

    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    InsertListBoxItem(MDI.RecvEdit_hWnd, "You are now connected.", -1);

    SimpleClientSend("::RequestFirstStatement");

    while(MyClient.Connected)
    {
        SendSize = GetQueuItem(&QS, 0, SendBuffer);
        if(SendSize != -1)
        {
            SendBuffer[SendSize] = '\0';
            MyClient.SetSendDataEx(SendBuffer, SendSize);
        }

        if(MyClient.GetReceiveData(ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int CmdResult = ProcessCommand(ReceiveData, ReceiveSize);
            if(CmdResult == COMMAND_RESULT_UNKNOWN)
            {
                InsertListBoxItem(MDI.RecvEdit_hWnd, "Received unknown command.", -1);
            }
            else if(CmdResult == COMMAND_RESULT_DISCONNECT){
                return ThreadWaitForDisconnect(&MyClient);
            }
            else if(CmdResult == COMMAND_RESULT_OK){
                // All is well
            }
            else{
                InsertListBoxItem(MDI.RecvEdit_hWnd, "An error occured processing a received command.", -1);
                return ThreadWaitForDisconnect(&MyClient);
            }
        }
        else Sleep(1);

        Sleep(glTCPLoopDelay);
    }

    return ThreadWaitForDisconnect(&MyClient);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

